#ifndef IPHYSICALBODY_H_
#define IPHYSICALBODY_H_

#include "IPhysicalObject.h"
#include "../DataTypes/DataBody.h"

namespace PhysicsEngine
{

class IPhysicalBody: public PhysicsEngine::IPhysicalObject
{
public:
	IPhysicalBody();
	IPhysicalBody(int objectid, int materialid, float mass, Vector3f position, Vector3f rotation);
	virtual ~IPhysicalBody();
	Vector3f GetPosition();
	Vector3f GetRotation();
	virtual Vector3f GetAngularVelocity()=0;
	virtual Vector3f GetLinearVelocity()=0;
	DataQuaternion GetQuaternion();
	int GetMaterialId();
	float GetMass();
	void SetMaterialId(int value);
	void SetMass(float mass);
	void SetPosition(Vector3f value);
	virtual void SetPhysicalPosition(float posx, float posy,float posz)=0;
	void SetRotation(Vector3f value);
	void SetQuaternion(DataQuaternion value);
	virtual void RotateObject(float axis_x, float axis_y, float axis_z, float angle)=0;
	DataObject *GetDataObject();
	virtual DataBody* GetDataBody()=0;
	virtual void UpdateData()=0;
	
private:
	Vector3f position;
	Vector3f rotation;
	DataQuaternion quaternion;
	int materialid;
	float mass;
};

}

#endif /*IPHYSICALBODY_H_*/
